package com.example.tienda

import android.content.Context
import android.content.Intent
import android.graphics.Canvas
import android.graphics.Color
import android.graphics.Paint
import android.graphics.pdf.PdfDocument
import android.net.Uri
import android.os.Environment
import android.widget.Toast
import androidx.core.content.FileProvider
import java.io.File
import java.io.FileOutputStream

class PDFManager(val context: Context) {

    fun generarVoucherPDF(data: VoucherData) {
        // 1. Crear el documento
        val documento = PdfDocument()

        // 2. Configurar la página (Ancho: 300px, Alto: 500px - Tamaño tipo ticket)
        val pageInfo = PdfDocument.PageInfo.Builder(300, 500, 1).create()
        val pagina = documento.startPage(pageInfo)
        val canvas: Canvas = pagina.canvas
        val paint = Paint()

        // --- DISEÑO DEL TICKET ---

        // Título Tienda
        paint.color = Color.BLACK
        paint.textSize = 18f
        paint.isFakeBoldText = true
        paint.textAlign = Paint.Align.CENTER
        canvas.drawText("TIENDA GRUPO DVH", 150f, 40f, paint)

        // Subtítulos
        paint.textSize = 12f
        paint.isFakeBoldText = false
        paint.color = Color.DKGRAY
        canvas.drawText("RUC: 20123456789", 150f, 60f, paint)
        canvas.drawText("Fecha: ${data.fecha}", 150f, 80f, paint)

        // Línea separadora
        paint.strokeWidth = 2f
        canvas.drawLine(10f, 100f, 290f, 100f, paint)

        // Detalles del Producto
        paint.textAlign = Paint.Align.LEFT
        paint.color = Color.BLACK
        paint.textSize = 14f

        // Cabeceras
        canvas.drawText("Producto", 20f, 130f, paint)
        canvas.drawText("Total", 230f, 130f, paint) // Alineado a la derecha visualmente

        // Valores
        paint.isFakeBoldText = true
        canvas.drawText(data.producto, 20f, 160f, paint)

        paint.isFakeBoldText = false
        canvas.drawText("Cant: ${data.cantidad}  x  S/. ${data.precioUnit}", 20f, 180f, paint)

        paint.textSize = 16f
        paint.isFakeBoldText = true
        canvas.drawText("S/. ${data.total}", 230f, 160f, paint)

        // Línea final
        canvas.drawLine(10f, 220f, 290f, 220f, paint)

        // Total Final Grande
        paint.textSize = 20f
        paint.textAlign = Paint.Align.CENTER
        canvas.drawText("TOTAL A PAGAR", 150f, 250f, paint)
        canvas.drawText("S/. ${String.format("%.2f", data.total)}", 150f, 280f, paint)

        // Pie de página
        paint.textSize = 10f
        paint.isFakeBoldText = false
        paint.color = Color.GRAY
        canvas.drawText("¡Gracias por su compra!", 150f, 350f, paint)
        canvas.drawText("www.emerson.grupodvh.com", 150f, 370f, paint)

        // 3. Finalizar página
        documento.finishPage(pagina)

        // 4. Guardar archivo
        val directorio = context.getExternalFilesDir(Environment.DIRECTORY_DOCUMENTS)
        val archivo = File(directorio, "Voucher_${System.currentTimeMillis()}.pdf")

        try {
            documento.writeTo(FileOutputStream(archivo))
            Toast.makeText(context, "PDF Generado en Documentos", Toast.LENGTH_LONG).show()
            abrirPDF(archivo) // Abrir automáticamente
        } catch (e: Exception) {
            e.printStackTrace()
            Toast.makeText(context, "Error al generar PDF", Toast.LENGTH_SHORT).show()
        }

        documento.close()
    }

    private fun abrirPDF(archivo: File) {
        val uri = FileProvider.getUriForFile(
            context,
            "${context.packageName}.provider",
            archivo
        )

        val intent = Intent(Intent.ACTION_VIEW)
        intent.setDataAndType(uri, "application/pdf")
        intent.flags = Intent.FLAG_GRANT_READ_URI_PERMISSION or Intent.FLAG_ACTIVITY_NO_HISTORY

        val intentChooser = Intent.createChooser(intent, "Abrir Voucher")
        try {
            context.startActivity(intentChooser)
        } catch (e: Exception) {
            Toast.makeText(context, "No tienes App para ver PDF", Toast.LENGTH_SHORT).show()
        }
    }
}