# 📱 TIENDA ONLINE - Sistema de Gestión con Generación de Vouchers PDF

## ✅ IMPLEMENTACIONES COMPLETADAS

### 🎯 Funcionalidades Agregadas:

#### 1. **PDFManager.kt** - Generador de Vouchers en PDF
- ✅ Clase profesional para generar comprobantes de venta
- ✅ Diseño elegante con tablas, colores corporativos y formato profesional
- ✅ Dos modos de generación:
  - `generarVoucherVenta()` - Para múltiples productos seleccionados
  - `generarVoucherSimple()` - Para un solo producto
- ✅ Abre automáticamente el PDF generado
- ✅ Guarda en: Documents/Tienda_Vouchers/

#### 2. **MainActivity.kt Actualizado**
- ✅ **Botón de selección múltiple**: Checkbox en cada tarjeta de producto
- ✅ **Botón "GENERAR VOUCHER"**: Aparece cuando hay productos seleccionados
- ✅ **Botón individual por producto**: Icono de envío (Send) para generar voucher de un solo item
- ✅ Feedback visual: Las tarjetas seleccionadas cambian de color
- ✅ URL actualizada: `http://nazariolayme.icu/api_tienda/`

#### 3. **Archivos PHP del API** (api_scripts/)
Todos los scripts están listos con las credenciales correctas:

**📁 conexion.php**
```php
$database = "nazariolayme_tienda";
$username = "nazariolayme_admin";
$password = "nazario2025";
```

**📁 database.sql**
- Script completo para crear base de datos
- Tablas: `categorias` y `productos`
- Datos de ejemplo: 8 categorías, 18 productos

**📁 Endpoints del API:**
- `listar.php` - Listar todos los productos
- `listar_categorias.php` - Listar categorías
- `consultar.php?codigo=X` - Buscar producto por código
- `guardar.php` - Crear/actualizar producto (POST JSON)
- `borrar.php` - Eliminar producto (POST JSON)

#### 4. **Configuración Android**
- ✅ AndroidManifest.xml actualizado con permisos de almacenamiento
- ✅ FileProvider configurado para compartir PDFs
- ✅ file_paths.xml creado
- ✅ Dependencias agregadas:
  - Volley 1.2.1
  - Navigation Compose 2.7.7
  - iText7 7.2.5 (para PDFs)

---

## 🚀 PASOS PARA EJECUTAR

### 1️⃣ Subir Archivos PHP al Servidor

Desde tu directorio `api_scripts/`, sube al servidor:
- `conexion.php`
- `listar.php`
- `listar_categorias.php`
- `consultar.php`
- `guardar.php`
- `borrar.php`

**Ubicación en el servidor:** `http://nazariolayme.icu/api_tienda/`

### 2️⃣ Crear Base de Datos MySQL

1. Accede a tu panel de hosting (cPanel, phpMyAdmin)
2. Abre **phpMyAdmin**
3. Ejecuta el archivo `database.sql` completo
4. Verifica que se crearon:
   - Base de datos: `nazariolayme_tienda`
   - Tabla `categorias` (8 registros)
   - Tabla `productos` (18 registros)

### 3️⃣ Sincronizar Proyecto Android

```powershell
cd "C:\Users\Cyper Ohzy\AndroidStudioProjects\tienda"
.\gradlew clean build
```

O en Android Studio:
- **File → Sync Project with Gradle Files**
- Espera a que descargue iText7 y todas las dependencias

### 4️⃣ Compilar y Ejecutar

1. Conecta tu dispositivo Android o inicia un emulador
2. En Android Studio: **Run → Run 'app'** (Shift+F10)
3. La app se instalará y ejecutará automáticamente

---

## 📝 CÓMO USAR LA APP

### 🛒 Pantalla "Catálogo"
1. **Ver productos**: Lista con código, nombre, descripción, categoría y precio
2. **Seleccionar productos**: Toca cualquier tarjeta o checkbox
3. **Generar voucher múltiple**: Botón superior "GENERAR VOUCHER (N)"
4. **Voucher individual**: Icono de envío (✉️) en cada producto

### ✏️ Pantalla "Gestión"
1. **Buscar**: Ingresa código y presiona 🔍
2. **Crear nuevo**: Código libre → Completa campos → GUARDAR
3. **Editar**: Código existente → Modifica datos → GUARDAR
4. **Eliminar**: Código existente → Botón rojo ELIMINAR

### 📄 Vouchers Generados
- **Ubicación**: Documents/Tienda_Vouchers/
- **Formato**: Voucher_YYYYMMDD_HHMMSS.pdf
- **Contenido**:
  - Encabezado con logo y datos
  - Tabla de productos
  - Total destacado
  - Información de contacto

---

## 🛠️ SOLUCIÓN DE PROBLEMAS

### ❌ Error: "Unresolved reference 'itextpdf'"
**Solución:**
```powershell
.\gradlew clean
.\gradlew build --refresh-dependencies
```
Luego en Android Studio: **File → Invalidate Caches / Restart**

### ❌ No genera PDFs
**Verifica:**
1. Permisos de almacenamiento otorgados (Android 13+)
2. Instalar un lector PDF (Adobe Reader, Google PDF Viewer)

### ❌ Error de conexión al API
**Verifica:**
1. Internet activo en el dispositivo
2. URL correcta: `http://nazariolayme.icu/api_tienda/`
3. Archivos PHP subidos al servidor
4. Base de datos creada correctamente

### ❌ Base de datos no se conecta
**Revisa en conexion.php:**
```php
$database = "nazariolayme_tienda";
$username = "nazariolayme_admin";
$password = "nazario2025";
```

---

## 📦 ESTRUCTURA DEL PROYECTO

```
tienda/
├── app/
│   ├── src/main/
│   │   ├── java/com/example/tienda/
│   │   │   ├── MainActivity.kt          ← UI principal
│   │   │   └── PDFManager.kt            ← Generador de PDFs
│   │   ├── res/
│   │   │   └── xml/
│   │   │       └── file_paths.xml       ← FileProvider config
│   │   └── AndroidManifest.xml          ← Permisos
│   └── build.gradle.kts                 ← Dependencias
├── api_scripts/
│   ├── conexion.php                     ← Conexión DB
│   ├── listar.php                       ← GET productos
│   ├── listar_categorias.php            ← GET categorías
│   ├── consultar.php                    ← GET producto por código
│   ├── guardar.php                      ← POST crear/editar
│   ├── borrar.php                       ← POST eliminar
│   └── database.sql                     ← Script DB
└── README_VOUCHERS.md                   ← Este archivo
```

---

## 🎨 CARACTERÍSTICAS DEL DISEÑO

- **Tema**: Material Design 3
- **Colores**: Azul petróleo corporativo (#00677F)
- **Estilo**: Tarjetas planas (flat design)
- **Tipografía**: Roboto (sistema)
- **Navegación**: Bottom Navigation Bar
- **Vouchers**: Diseño profesional con branding

---

## 📞 INFORMACIÓN DE CONTACTO

**App desarrollada con:**
- Kotlin + Jetpack Compose
- Material Design 3
- Volley (HTTP)
- iText7 (PDF)

**API Backend:**
- PHP 7.4+
- MySQL 5.7+
- JSON REST

---

## 🔄 PRÓXIMAS MEJORAS SUGERIDAS

1. 🔐 Autenticación de usuarios
2. 💾 Persistencia local (Room Database)
3. 📊 Dashboard con estadísticas
4. 🖼️ Soporte de imágenes de productos
5. 🛒 Carrito de compras completo
6. 📧 Envío de vouchers por email
7. 💳 Integración de pagos
8. 📱 Notificaciones push

---

## ✅ CHECKLIST DE VALIDACIÓN

- [x] PDFManager.kt creado
- [x] Botones de voucher agregados
- [x] Selección múltiple implementada
- [x] URL del API actualizada
- [x] Scripts PHP con credenciales correctas
- [x] database.sql completo
- [x] AndroidManifest.xml configurado
- [x] file_paths.xml creado
- [x] Dependencias agregadas (iText7)
- [x] Proyecto compilado exitosamente

---

**¡Todo está listo para usar! 🎉**

Si tienes algún problema, revisa la sección "SOLUCIÓN DE PROBLEMAS" o contacta al desarrollador.

