# 🚀 INSTRUCCIONES RÁPIDAS DE DESPLIEGUE

## 📤 SUBIR ARCHIVOS AL SERVIDOR (FTP/cPanel)

### Opción 1: Via cPanel File Manager
1. Accede a: http://nazariolayme.icu/cpanel
2. Abre **File Manager**
3. Navega a: `public_html/`
4. Crea carpeta: `api_tienda`
5. Sube estos archivos:
   ```
   ✅ conexion.php
   ✅ listar.php
   ✅ listar_categorias.php
   ✅ consultar.php
   ✅ guardar.php
   ✅ borrar.php
   ```

### Opción 2: Via FTP (FileZilla)
```
Host: ftp.nazariolayme.icu
Usuario: (tu usuario FTP)
Puerto: 21
```
Sube archivos a: `/public_html/api_tienda/`

---

## 🗄️ CREAR BASE DE DATOS

### Paso 1: Crear la Base de Datos
1. cPanel → **MySQL Databases**
2. **Create New Database**: `nazariolayme_tienda`
3. **Create New User**:
   - Username: `nazariolayme_admin`
   - Password: `nazario2025`
4. **Add User To Database** → All Privileges

### Paso 2: Importar Tablas y Datos
1. cPanel → **phpMyAdmin**
2. Selecciona base de datos: `nazariolayme_tienda`
3. Tab **Import**
4. Choose file: `database.sql`
5. Click **Go**

### Verificación:
```sql
-- Ejecuta en phpMyAdmin:
SELECT COUNT(*) FROM categorias;  -- Debe retornar 8
SELECT COUNT(*) FROM productos;   -- Debe retornar 18
```

---

## 🧪 PROBAR EL API

Abre en tu navegador:

### Test 1: Listar Productos
```
http://nazariolayme.icu/api_tienda/listar.php
```
**Esperado:** JSON con array de productos

### Test 2: Listar Categorías
```
http://nazariolayme.icu/api_tienda/listar_categorias.php
```
**Esperado:** JSON con 8 categorías

### Test 3: Consultar Producto
```
http://nazariolayme.icu/api_tienda/consultar.php?codigo=1001
```
**Esperado:** JSON con laptop HP

---

## 📱 EJECUTAR LA APP

### En Android Studio:
1. **Sync Project with Gradle Files** (Ctrl+Shift+O)
2. Espera que descargue dependencias (iText7)
3. **Build → Clean Project**
4. **Build → Rebuild Project**
5. **Run → Run 'app'** (Shift+F10)

### Desde Terminal:
```powershell
cd "C:\Users\Cyper Ohzy\AndroidStudioProjects\tienda"
.\gradlew clean assembleDebug
.\gradlew installDebug
```

---

## ✅ CHECKLIST DE VALIDACIÓN

### Backend (Servidor):
- [ ] Carpeta `api_tienda` creada
- [ ] 6 archivos PHP subidos
- [ ] Base de datos creada
- [ ] Usuario MySQL configurado
- [ ] Datos importados (8 categorías, 18 productos)
- [ ] URLs accesibles desde navegador

### Frontend (Android):
- [ ] Gradle sincronizado
- [ ] Dependencias descargadas
- [ ] Proyecto compilado sin errores
- [ ] App instalada en dispositivo
- [ ] Conexión a internet activa

### Funcionalidades:
- [ ] Lista de productos carga correctamente
- [ ] Se pueden seleccionar productos
- [ ] Botón "GENERAR VOUCHER" aparece
- [ ] PDF se genera al presionar botón
- [ ] PDF se abre automáticamente
- [ ] Formulario de gestión funciona
- [ ] Búsqueda por código funciona

---

## 🐛 DIAGNÓSTICO DE ERRORES COMUNES

### ❌ "Connection failed" en la app
**Causa:** API no accesible
**Solución:**
1. Verifica que los archivos PHP estén en: `public_html/api_tienda/`
2. Prueba en navegador: http://nazariolayme.icu/api_tienda/listar.php
3. Revisa permisos de archivos (644)

### ❌ "Error de conexión" en database
**Causa:** Credenciales incorrectas
**Solución:**
Edita `conexion.php`:
```php
$database = "nazariolayme_tienda";  // ← Nombre correcto
$username = "nazariolayme_admin";    // ← Usuario correcto
$password = "nazario2025";           // ← Contraseña correcta
```

### ❌ "Unresolved reference 'itextpdf'"
**Causa:** Dependencias no descargadas
**Solución:**
```powershell
.\gradlew --refresh-dependencies
.\gradlew clean build
```

### ❌ PDF no se abre
**Causa:** Sin lector PDF instalado
**Solución:**
Instala desde Play Store:
- Google PDF Viewer
- Adobe Acrobat Reader

---

## 📊 ESTRUCTURA DE LA BASE DE DATOS

### Tabla: `categorias`
```sql
CREATE TABLE categorias (
    id_categoria INT PRIMARY KEY AUTO_INCREMENT,
    nombre VARCHAR(100),
    descripcion TEXT,
    fecha_creacion TIMESTAMP
);
```

### Tabla: `productos`
```sql
CREATE TABLE productos (
    codigo INT PRIMARY KEY,
    nombre VARCHAR(200),
    descripcion TEXT,
    precio DECIMAL(10,2),
    id_categoria INT,
    stock INT,
    imagen_url VARCHAR(500),
    activo TINYINT(1),
    fecha_creacion TIMESTAMP,
    fecha_modificacion TIMESTAMP,
    FOREIGN KEY (id_categoria) REFERENCES categorias(id_categoria)
);
```

---

## 🎯 ENDPOINTS DEL API

| Método | Endpoint | Parámetros | Descripción |
|--------|----------|------------|-------------|
| GET | `/listar.php` | - | Lista todos los productos |
| GET | `/listar_categorias.php` | - | Lista todas las categorías |
| GET | `/consultar.php` | `?codigo=X` | Busca producto por código |
| POST | `/guardar.php` | JSON body | Crea/actualiza producto |
| POST | `/borrar.php` | JSON body | Elimina producto |

### Ejemplo POST guardar.php:
```json
{
  "codigo": 9001,
  "nombre": "Nuevo Producto",
  "descripcion": "Descripción detallada",
  "precio": 99.90,
  "id_categoria": 1,
  "stock": 10
}
```

---

## 📞 CONTACTO Y SOPORTE

Si encuentras algún problema:

1. Revisa este documento completo
2. Verifica el README_VOUCHERS.md
3. Consulta los logs de Android Studio
4. Revisa error_log en cPanel

**URLs importantes:**
- cPanel: http://nazariolayme.icu/cpanel
- phpMyAdmin: http://nazariolayme.icu/phpmyadmin
- API Base: http://nazariolayme.icu/api_tienda/

---

**¡Listo para producción! 🚀**

